<?php

class MainGroupsActivationTest extends WebControllerTestCase
{
	const DUPLICATE_LOGIN = 'TEST';	//ten użytkownik powinien istniec w bazie danych

	/**
	 * FS#91 - W panelu admina można utworzyć dwóch adminów z takim samym loginem!
	 * http://pyramidlab.pl/tasks/index.php?do=details&task_id=91&project=1
	 */
	public function testActionCreateDuplicate()
	{
		$this->login('admin');
		$this->open('administration/admin/create');
		$this->assertTextPresent('Dodaj administratora');
		$this->assertElementPresent("//label[@class='required' and @for='Admin_login']");

		$this->type('name=Admin[imie]', self::DUPLICATE_LOGIN);
		$this->type('name=Admin[nazwisko]', self::DUPLICATE_LOGIN);
		$this->type('name=Admin[login]', self::DUPLICATE_LOGIN);
		$this->type('name=Admin[haslo]', self::DUPLICATE_LOGIN);
		$this->type('name=Admin[hasloPowtorzone]', self::DUPLICATE_LOGIN);
		$this->type('name=Admin[email]', 'test@test.com');
		$this->type('name=Admin[telefon]', '1234567890');

		$this->clickAndWait("//input[@type='submit']");
		$this->assertLocation(TEST_BASE_URL . 'administration/admin/create');
		$this->assertElementPresent("//label[@class='error required' and @for='Admin_login']");
	}
}
